uniform sampler2DRect texture;
uniform sampler2DRect map;
uniform vec2 size;
uniform vec2 offset;
uniform bool lumaKey;
void main()
{
    vec4 map = texture2DRect(map, gl_TexCoord[0].xy);
    if ( map.w == 0.0 )
        discard;
    
    map.x = map.x * size.x - offset.x;
    map.y = map.y * size.y - offset.y;
    gl_FragColor = texture2DRect(texture, map.xy);
    gl_FragColor.rgba = gl_FragColor.rgba * map.z;
    if ( lumaKey )
    {
        gl_FragColor.r = 1.0;
        gl_FragColor.g = 1.0;
        gl_FragColor.b = 1.0;
    }
}